<?php $__env->startSection('body'); ?>
    <h1 class="text-uppercase text-center"><?php echo e($category->name); ?></h1>
    <hr>
    <div class="d-flex align-item-center justify-content-center flex-wrap">
        <?php $__empty_1 = true; $__currentLoopData = $category->nominees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nominee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="card text-center rounded-3 shadow border-0 m-3 h-100" style="width: 320px;">
            
            <div class="card-body pb-0">
                <div class="mx-auto mb-3 border border-light rounded-circle bg-light" style="width: 150px; height: 150px;">
                    <img src="<?php echo e(Storage::url($nominee->image)); ?>" class="nominee-img img-fluid rounded-circle w-100 h-100" alt="<?php echo e($nominee->name); ?>" />
                </div>
                <h3 class="card-title fw-bold mb-2 fs-5 text-uppercase"><?php echo e($nominee->name); ?></h3>
                <blockquote class="blockquote">
                    <p class="mb-4"><em><?php echo e($nominee->tagline); ?></em></p>
                </blockquote>
            </div>
            <div class="card-footer bg-transparent">
                <?php if($votingStatus === 'voting active'): ?>
                    <?php if(!isUserLogin()): ?>
                        <div class="d-grid">
                            <a href="<?php echo e(route('login')); ?>" class="btn btn-primary btn-lg rounded-pill text-uppercase fw-medium">login to vote</a>
                        </div>
                    <?php else: ?>
                        <?php if($votedNominee): ?>
                            <h4 class="text-uppercase fw-medium fs-6">
                            <?php if($votedNominee->id === $nominee->id): ?>
                                <span class="text-success">voted <i class="ti ti-check"></i></span>
                            <?php else: ?>
                                <span class="text-error">not voted <i class="ti ti-x"></i></span>
                            <?php endif; ?>
                            </h4>
                        <?php else: ?>
                            <form class="d-grid" action="<?php echo e(route('nominee.vote', ['nominee' => $nominee->id])); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn btn-primary btn-lg rounded-pill text-uppercase fw-medium">vote now</button>
                            </form>
                        <?php endif; ?>
                    <?php endif; ?>
                <?php else: ?>
                    <h4 class="text-uppercase fw-medium fs-6 text-warning"><?php echo e($votingStatus); ?></h4>
                <?php endif; ?>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <h4 class="text-center text-uppercase fw-medium">no nominees in this category</h4>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/delrzrzk/jda.mygma.xyz/resources/views/pages/category.blade.php ENDPATH**/ ?>