<!doctype html>
<html lang="en">

    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title><?php echo e(env('COMPANY_NAME')); ?></title>
        <link rel="stylesheet" href="<?php echo e(asset('assets/css/styles.min.css')); ?>" />
        <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
        <style>
            .sidebar-nav ul .sidebar-item .sidebar-link:hover, .sidebar-nav ul .sidebar-item.selected > .sidebar-link, .sidebar-nav ul .sidebar-item.selected > .sidebar-link.active, .sidebar-nav ul .sidebar-item > .sidebar-link.active{
                border-radius: var(--bs-border-radius-pill) !important;
            }
            .nominee-img{
                transition: all .3s ease-in-out 0s;
                cursor: pointer;
            }
            .nominee-img:hover{
                transform: scale(0.9);
            }
            .text-error{
                color: rgb(220, 53, 69);
            }
        </style>
        <?php echo $__env->yieldPushContent('style'); ?>
    </head>

    <body class="bg-light">
        <div class="page-wrapper" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full"
            data-sidebar-position="fixed" data-header-position="fixed">
            <?php echo $__env->make('includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="body-wrapper">
                <header class="app-header">
                    <nav class="navbar navbar-expand-lg navbar-light">
                        <ul class="navbar-nav">
                            <li class="nav-item d-block d-xl-none">
                                <a class="nav-link sidebartoggler nav-icon-hover" id="headerCollapse"
                                    href="javascript:void(0)">
                                    <i class="ti ti-menu-2"></i>
                                </a>
                            </li>
                            
                        </ul>
                        
                    </nav>
                </header>
                <div class="container-fluid">
                    <?php echo $__env->yieldContent('body'); ?>
                </div>
            </div>
        </div>
        <script src="<?php echo e(asset('assets/libs/jquery/dist/jquery.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/libs/bootstrap/dist/js/bootstrap.bundle.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/js/sidebarmenu.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/js/app.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/libs/simplebar/dist/simplebar.js')); ?>"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
        <script>
			window.addEventListener('alert', event => {
                //console.log('event', event.detail[0]);
				const type = event.detail[0].type;
				const message = event.detail[0].message;
				const title = event.detail[0].title ?? '';
				const options = {
					'closeButton': true,
					'progressBar': true,
					'showDuration': '300',
					'hideDuration': '5000',
					'timeOut': '5000',
				};
				switch(type){
					case 'success':
						toastr.success(message, title ?? '', options);
						break;
					case 'warning':
						toastr.warning(message, title ?? '', options);
						break;
					case 'error':
						toastr.error(message, title ?? '', options);
						break;
					case 'info':
						toastr.info(message, title ?? '', options);
						break;
					default:
						toastr.info(message, title ?? '', options);
				};
			});
		</script>
        <?php if(Session::has('alert')): ?>
        <script>
            let alertEvent = new CustomEvent('alert', {
                detail: [{
                    type: '<?php echo e(session('alert')['type']); ?>',
                    message: '<?php echo e(session('alert')['message']); ?>',
                    title: '<?php echo e(session('alert')['title']); ?>',
                }]
            });
            window.dispatchEvent(alertEvent);
        </script>
        <?php endif; ?>
        <?php echo $__env->yieldPushContent('script'); ?>
    </body>

</html>
<?php /**PATH /home/delrzrzk/jda.mygma.xyz/resources/views/layouts/master.blade.php ENDPATH**/ ?>